/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.projector.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.client.ClientConfig;
import dev.compactmods.crafting.client.render.CCRenderTypes;
import dev.compactmods.crafting.client.render.CubeRenderHelper;
import dev.compactmods.crafting.client.render.EnumCubeFaceCorner;
import dev.compactmods.crafting.client.render.RotationSpeed;
import dev.compactmods.crafting.projector.EnumProjectorColorType;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import dev.compactmods.crafting.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.LazyOptional;

public class FieldProjectorRenderer
implements BlockEntityRenderer<FieldProjectorEntity> {
    public static final ResourceLocation FIELD_DISH_RL = new ResourceLocation("compactcrafting", "block/field_projector_dish");
    private BakedModel bakedModelCached;
    private LazyOptional<IMiniaturizationField> field = LazyOptional.empty();

    public FieldProjectorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FieldProjectorEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        long gameTime = tile.m_58904_().m_46467_();
        this.renderDish(tile, matrixStack, buffers, combinedLightIn, combinedOverlayIn, gameTime);
        AABB bounds = tile.getField().map(field -> {
            double scale = MathUtil.calculateFieldScale(field);
            return field.getBounds().m_82406_((1.0 - scale) * ((double)field.getFieldSize().getSize() / 2.0));
        }).orElseGet(() -> {
            BlockState state = tile.m_58900_();
            MiniaturizationFieldSize fieldSize = (MiniaturizationFieldSize)((Object)((Object)state.m_61143_(FieldProjectorBlock.SIZE)));
            BlockPos center = fieldSize.getCenterFromProjector(tile.m_58899_(), (Direction)state.m_61143_((Property)FieldProjectorBlock.FACING));
            return fieldSize.getBoundsAtPosition(center);
        });
        matrixStack.m_85836_();
        this.drawScanLine(tile, matrixStack, buffers, bounds, gameTime);
        this.drawFieldFace(tile, matrixStack, buffers, bounds);
        this.drawProjectorArcs(tile, matrixStack, buffers, bounds, gameTime);
        matrixStack.m_85849_();
    }

    private BakedModel getModel() {
        if (this.bakedModelCached == null) {
            ModelManager models = Minecraft.m_91087_().m_91289_().m_110907_().m_110881_();
            this.bakedModelCached = models.getModel(FIELD_DISH_RL);
        }
        return this.bakedModelCached;
    }

    private void renderDish(FieldProjectorEntity te, PoseStack mx, MultiBufferSource buffer, int combinedLight, int combinedOverlay, long gameTime) {
        BlockState state = te.m_58900_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        VertexConsumer cutoutBlocks = buffer.m_6299_(Sheets.m_110790_());
        BakedModel baked = this.getModel();
        mx.m_85836_();
        mx.m_85837_(0.5, 0.0, 0.5);
        double yaw = Math.sin(Math.toDegrees(gameTime) / (double)RotationSpeed.MEDIUM.getSpeed()) * 10.0;
        Direction facing = (Direction)state.m_61143_((Property)FieldProjectorBlock.FACING);
        if (facing != Direction.WEST) {
            float angle = facing.m_122435_() - 90.0f;
            mx.m_85845_(Vector3f.f_122224_.m_122240_(angle));
        }
        float yDiskOffset = -0.66f;
        mx.m_85837_(0.0, (double)(-yDiskOffset), 0.0);
        mx.m_85845_(Vector3f.f_122227_.m_122240_((float)yaw));
        mx.m_85837_(0.0, (double)yDiskOffset, 0.0);
        mx.m_85837_(-0.5, 0.0, -0.5);
        int faceColor = this.getProjectionColor(EnumProjectorColorType.PROJECTOR_FACE);
        float red = (float)FastColor.ARGB32.m_13665_((int)faceColor) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)faceColor) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)faceColor) / 255.0f;
        blockRenderer.m_110937_().renderModel(mx.m_85850_(), cutoutBlocks, state, baked, red, green, blue, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        mx.m_85849_();
    }

    private void drawFieldFace(FieldProjectorEntity tile, PoseStack mx, MultiBufferSource buffers, AABB fieldBounds) {
        Direction projectorDir = tile.getProjectorSide();
        Vec3 tilePos = new Vec3((double)tile.m_58899_().m_123341_(), (double)tile.m_58899_().m_123342_(), (double)tile.m_58899_().m_123343_());
        boolean hoveringProjector = false;
        HitResult hr = Minecraft.m_91087_().f_91077_;
        if (hr instanceof BlockHitResult) {
            hoveringProjector = ((BlockHitResult)hr).m_82425_().equals((Object)tile.m_58899_());
        }
        if (ClientConfig.doDebugRender() && hoveringProjector) {
            VertexConsumer lineBuilder = buffers.m_6299_(RenderType.m_110504_());
            Vec3 debugOrigin = new Vec3(0.5, 0.5, 0.5);
            Vec3 bottomLeft = CubeRenderHelper.getCubeFacePoint(fieldBounds, projectorDir, EnumCubeFaceCorner.BOTTOM_LEFT).m_82546_(tilePos);
            Vec3 bottomRight = CubeRenderHelper.getCubeFacePoint(fieldBounds, projectorDir, EnumCubeFaceCorner.BOTTOM_RIGHT).m_82546_(tilePos);
            Vec3 topLeft = CubeRenderHelper.getCubeFacePoint(fieldBounds, projectorDir, EnumCubeFaceCorner.TOP_LEFT).m_82546_(tilePos);
            Vec3 topRight = CubeRenderHelper.getCubeFacePoint(fieldBounds, projectorDir, EnumCubeFaceCorner.TOP_RIGHT).m_82546_(tilePos);
            mx.m_85836_();
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -65536, debugOrigin);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -65536, bottomLeft);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -16711936, debugOrigin);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -16711936, bottomRight);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -16776961, debugOrigin);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -16776961, topRight);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -1, debugOrigin);
            CubeRenderHelper.addColoredVertex(lineBuilder, mx, -1, topLeft);
            mx.m_85849_();
        }
        VertexConsumer builder = buffers.m_6299_(CCRenderTypes.FIELD_RENDER_TYPE);
        double expansion = 0.005;
        AABB slightlyBiggerBecauseFoxes = fieldBounds.m_82363_(expansion, expansion, expansion).m_82363_(-expansion, -expansion, -expansion).m_82383_(tilePos.m_82548_());
        int color = this.getProjectionColor(EnumProjectorColorType.FIELD);
        switch (projectorDir) {
            case NORTH: {
                CubeRenderHelper.drawCubeFace(builder, mx, slightlyBiggerBecauseFoxes, color, Direction.UP);
                CubeRenderHelper.drawCubeFace(builder, mx, slightlyBiggerBecauseFoxes, color, projectorDir);
                break;
            }
            case SOUTH: {
                CubeRenderHelper.drawCubeFace(builder, mx, slightlyBiggerBecauseFoxes, color, Direction.DOWN);
                CubeRenderHelper.drawCubeFace(builder, mx, slightlyBiggerBecauseFoxes, color, projectorDir);
                break;
            }
            default: {
                CubeRenderHelper.drawCubeFace(builder, mx, slightlyBiggerBecauseFoxes, color, projectorDir);
            }
        }
    }

    private void drawProjectorArcs(FieldProjectorEntity tile, PoseStack mx, MultiBufferSource buffers, AABB fieldBounds, double gameTime) {
        try {
            VertexConsumer builder = buffers.m_6299_(CCRenderTypes.FIELD_RENDER_TYPE);
            Direction facing = tile.getProjectorSide();
            Vec3 tilePos = new Vec3((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5);
            mx.m_85836_();
            mx.m_85837_(0.5, 0.5, 0.5);
            int colorProjectionArc = this.getProjectionColor(EnumProjectorColorType.SCAN_LINE);
            Vec3 scanLeft = CubeRenderHelper.getScanLineRight(facing, fieldBounds, gameTime).m_82546_(tilePos);
            Vec3 scanRight = CubeRenderHelper.getScanLineLeft(facing, fieldBounds, gameTime).m_82546_(tilePos);
            Matrix4f p = mx.m_85850_().m_85861_();
            Matrix3f n = mx.m_85850_().m_85864_();
            builder.m_85982_(p, 0.0f, 0.2f, 0.0f).m_193479_(colorProjectionArc).m_85977_(n, 0.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(p, (float)scanLeft.f_82479_, (float)scanLeft.f_82480_, (float)scanLeft.f_82481_).m_193479_(colorProjectionArc).m_85977_(n, 0.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(p, (float)scanRight.f_82479_, (float)scanRight.f_82480_, (float)scanRight.f_82481_).m_193479_(colorProjectionArc).m_85977_(n, 0.0f, 0.0f, 0.0f).m_5752_();
            builder.m_85982_(p, 0.0f, 0.2f, 0.0f).m_193479_(colorProjectionArc).m_85977_(n, 0.0f, 0.0f, 0.0f).m_5752_();
            mx.m_85849_();
        }
        catch (Exception ex) {
            CompactCrafting.LOGGER.error((Object)ex);
        }
    }

    private void drawScanLine(FieldProjectorEntity tile, PoseStack mx, MultiBufferSource buffers, AABB fieldBounds, double gameTime) {
        VertexConsumer builder = buffers.m_6299_(RenderType.m_110504_());
        Vec3 tilePos = new Vec3((double)tile.m_58899_().m_123341_() + 0.5, (double)tile.m_58899_().m_123342_() + 0.5, (double)tile.m_58899_().m_123343_() + 0.5);
        mx.m_85836_();
        mx.m_85837_(0.5, 0.5, 0.5);
        int colorScanLine = this.getProjectionColor(EnumProjectorColorType.SCAN_LINE);
        Direction face = tile.getProjectorSide();
        Vec3 left = CubeRenderHelper.getScanLineLeft(face, fieldBounds, gameTime).m_82546_(tilePos);
        Vec3 right = CubeRenderHelper.getScanLineRight(face, fieldBounds, gameTime).m_82546_(tilePos);
        CubeRenderHelper.addColoredVertex(builder, mx, colorScanLine, left);
        CubeRenderHelper.addColoredVertex(builder, mx, colorScanLine, right);
        mx.m_85849_();
    }

    public boolean shouldRenderOffScreen(FieldProjectorEntity te) {
        return true;
    }

    public int getProjectionColor(EnumProjectorColorType type) {
        int base = ClientConfig.projectorColor;
        int red = FastColor.ARGB32.m_13665_((int)base);
        int green = FastColor.ARGB32.m_13667_((int)base);
        int blue = FastColor.ARGB32.m_13669_((int)base);
        switch (type) {
            case FIELD: 
            case SCAN_LINE: {
                return FastColor.ARGB32.m_13660_((int)50, (int)red, (int)green, (int)blue);
            }
            case PROJECTOR_FACE: {
                return FastColor.ARGB32.m_13660_((int)250, (int)red, (int)green, (int)blue);
            }
        }
        return 0xFFFFFF;
    }
}

